<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Director extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'image',
    ];

    public static function withDescription()
    {
        $query = self::join('director_descriptions as directorDesc', 'directorDesc.director_id', 'directors.id')
            ->where('directorDesc.language_id', currentLanguage()->id)
            ->select(['directors.image', 'directorDesc.*']);

        return $query->cursor();
    }

}
