<?php

namespace App\Http\Controllers\Admin;

use App\Language;
use App\Helpers\ImageHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\LanguageRequest; // for Validation


class LanguageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Display a Details for frontend website.
     *
     * @param $id
     * @param string $slug
     * @return \Illuminate\Http\Response
     */
    public function details ($id, $slug= '')
    {
        // dd($id);
        $language= Language::findOrFail($id);
        // $language=Language::find($id);
        // dd($language->url);
        if ($slug !== $language->name) {
            // return redirect()->to($language->url);
        }
        // dd($language);
        return view('language_details')
         ->withLanguage($language)
         ->withCanonical($language->url);
        // return view('language_details', compact('language') );
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        ImageHelper::resize('/photos/3/11.jpeg', 50, 50);
        //
        $language=(object) ['id'=> 0, 'name'=> '', 'local'=> ''];
        return view('language', compact('language'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  LanguageRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(LanguageRequest $request)
    {
        //
        dd($request->all());
        Language::insert(
		    ['name' => $request->name, 'local' => $request->local]
		);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
		$language=Language::find($id);
		//dd($language->name);
        return view('language', compact('language'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(LanguageRequest $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
