<?php

namespace App\Http\Controllers\Web;

use App\Career;
use App\CareerApplication;
use App\Country;
use App\Education;
use App\Helpers\ImageHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\CareerApplyRequest;
use App\Service;
use Illuminate\View\View;


class CareerController extends Controller
{
    private $view = 'web.careers.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
       $jobs = Career::withDescription();
       $title = __('careers.vacant_jobs');

        $pageTitle = explode(' ', __('main.career_page_title'));
        $pageTitle2 = array_pop($pageTitle);
        $pageTitle1 = implode(' ', $pageTitle);

       return view($this->view.'index', get_defined_vars());
    }


    public function careerApplyFrom(Career $career)
    {
        $title = __('careers.head');
        $action = route('career.apply', $career->id);
//        $specializations = Service::withDescription();
        $countries = Country::withDescription();
        $educations = Education::withDescription();
        $careerDetails = $career->currentDescription;
        $specializationName = $career->service->currentDescription->name;
        return view($this->view.'career_form', get_defined_vars());

    }

    public function careerApply(CareerApplyRequest $request, Career $career)
    {
        if ($request->ajax()){
            $data = $request->all();
            $data['career_id'] = $career->id;
            $data['service_id'] = $career->service->id;
            $data['cv'] = ImageHelper::upload($request->cv, 'career_applications');
            CareerApplication::create($data);
            return response()->json(['message' => __('careerApplications.application_send_success')]);
        }
    }

}
