<?php

namespace App\Http\Controllers\Web;

use App\Director;
use App\Doctor;
use App\Http\Controllers\Controller;
use App\Page;
use Illuminate\View\View;

class PageController extends Controller
{
    private $view = 'web.pages.';


    /**
     * Show the application dashboard.
     * @param $id
     * @param $type
     * @return View
     */

    public function show($id, $type)
    {

        $types = [
            'mvv' => 'mission-vision-values',
//            '7' => 'chairman-message',
            '14' => 'ceo-message',
            '13' => 'accreditation',
//            '12' => 'quality-department',
            '9' => 'patients-services',
            '10' => 'InPatient',
            '11' => 'nursing',
            '8' => 'patient-information',
        ];

        /**
         * 1,2,3 mission-vision-values
         * 7 chairman-message
         * 14 ceo-message
         * 13 accreditation
         * 12 quality-department
         * 9 patients-services
         * 10 InPatient
         * 11 nursing
         * 8 patient-information
         */

        if (!in_array($type, $types) || array_search($type, $types) != $id){
            return abort(404);
        }

        if ($type == 'mission-vision-values'){
            $pages = Page::withDescription([1,2,3])->toArray();
            $title = __('main.about_us');
        } else {

            $pages = Page::withDescription([$id]);
            $title = $pages->page_title ?? $pages->title;

            $description = $pages->description;
            $description = preg_replace('/\r\n/', '', $pages->description);

//            $titlePattern = "/<h1>(.*?)<\/h1>/";
//            $descPattern = "/<p>(.*?)<\/p>/";


            $titlePattern = "/<h1>(.*?)<\/h1>/";
            $descPattern = "/(<\/h1><p>(.*?)(<\/p><h1>))|(<\/h1><p>(.*?)(<\/p>))/";
//            $descPattern = "/<\/h1><p>(.*?)(<\/p><h1>)|(<\/p>)/";



            preg_match_all($titlePattern, $description, $titleMatches);
            preg_match_all($descPattern, $description, $descMatches);

            $titleMatches = $titleMatches[1] ?? [];
            $descMatches = $descMatches[0] ?? [];

//            dd($description);

//            dd($titleMatches, $descMatches);
//            dd($titleMatches);


        }

//        if ($type == 'chairman-message'){
//            $directors = Director::withDescription();
//        }

        if ($type == 'ceo-message'){
            $managerPage = Page::withDescription([15]);
            $managers = Director::withDescription();
            $managersTitle = explode(' ', __('main.our_managers'), 2);
            $managersTitle2 = array_pop($managersTitle);
            $managersTitle1 = implode(' ', $managersTitle);

        }


        if (in_array($type, ['accreditation', 'patient-information'])){
            $pageTitle1 = explode(' ', $pages->title, 2);
            $pageTitle12 = array_pop($pageTitle1);
            $pageTitle11 = implode(' ', $pageTitle1);

            $pageTitle2 = explode(' ', $pages->title_2, 2);
            $pageTitle22 = array_pop($pageTitle2);
            $pageTitle21 = implode(' ', $pageTitle2);
        }


        return view($this->view.$type, get_defined_vars());
    }

}
