<?php

namespace App\Http\Middleware;

use App\WebsiteVisitor;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class WebsiteVisitorCount
{
    /**
     * Handle an incoming request.
     *
     * @param  Request  $request
     * @param Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        if(!Session::has('visited') ||  date('Y-m-d') != (string)Session::get('visited')){
            // Store The visitor Ip in Visits data
            WebsiteVisitor::create(['ip' => request()->getClientIp()]);
            Session::put(['visited' => date('Y-m-d')]);
        }
        return $next($request);
    }
}
