<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Validation\ValidationException;
use Illuminate\Http\Exceptions\HttpResponseException;
use function foo\func;

/**
 * @property mixed fields
 * @property mixed module_name
 */
class ModuleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (! Auth::check()) {
            return false;
        }
        if(in_array(Auth::user()->role, ['super_admin', 'admin', 'sub_admin']))
        {
            return true;
        }

        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];
        $fields = request()->fields;
        $moduleName = request()->module_name;

        foreach ($moduleName as $path => $item) {
            $item = array_shift($item);
            foreach ($item as $local => $value) {
                if(empty($value)){
                    $fieldsRules  = [$path.'_module_name_'.$local => 'required'];
                    $rules= array_merge($rules, $fieldsRules);
                }
            }
        }

        foreach ($fields as $path => $field) {
            $field = array_shift($field);
            foreach ($field as $local => $array) {
                foreach ($array as $key => $value) {
                    $value = trim($value);
                    if(empty($value)){
                        $fieldsRules  = [$path.'_'.$key.'_'.$local => 'required'];
                        $rules= array_merge($rules, $fieldsRules);
                    }
                }
            }

        }

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $attributes = [];
        $fields = request()->fields;
        $moduleName = request()->module_name;
        foreach ($moduleName as $path => $item) {
            $item = array_shift($item);
            foreach ($item as $local => $value) {
                if(empty($value)){
                    $fieldAttribute  = [strtoupper($path).'_module_name_'.$local => $path.'Module Name '.$local];
                    $attributes= array_merge($fieldAttribute, $attributes);
                }
            }
        }


        foreach ($fields as $path => $field) {
            $field = array_shift($field);
            foreach ($field as $local => $array) {
                foreach ($array as $key => $value) {
                    $value = trim($value);
                    if(empty($value)){
                        $fieldAttribute  = [$path.'_'.$key.'_'.$local => $path.' '.str_replace('_', ' ', $key).' '.$local];
                        $attributes= array_merge($fieldAttribute, $attributes);
                    }
                }
            }

        }

        return $attributes;
    }


    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests

        if(Request::wantsJson()){
            $errors = (new ValidationException($validator))->errors();
            throw new HttpResponseException(response()->json(['errors' => $errors], 422));
        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
