<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class PartnerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (! Auth::check()) {
            return false;
        }
        if(in_array(Auth::user()->role, ['super_admin', 'admin', 'sub_admin']))
        {
            return true;
        }

        if(Auth::user()->hasModule( 'partners' ) )
        {
            return true;
        }
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules=['url' => 'required|url', 'type' => 'required|in:partner,insurance'];
//        $rules=['url' => 'required|url', 'type' => 'required|in:insurance'];

        foreach (languages() as $lang) {
            $lang_rules=[
                'name_'.$lang->local=> 'required|min:3|max:100',
//                'slug_'.$lang->local=> [
//                    "required",
//                    Rule::unique('partner_descriptions', 'slug')->ignore($this->partner? $this->partner->id : 0, 'partner_id')
//                ],
//                'keywords_'.$lang->local=> 'required|min:3',
//                'meta_description_'.$lang->local=> 'required|min:3',
//                'description_'.$lang->local=> 'required|min:3',
            ];
            $rules= array_merge($rules, $lang_rules);
        }

        $rules['image'] = 'required';

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $field = metaFields('partners');
        $local = getCurrentLocale();
        $attributes=[
            'url' => $field[$local]['url'] ?? __('partners.url'),
            'type' => $field[$local]['type'] ?? __('partners.type'),
            'image' => $field[$local]['image'] ?? __('partners.image')
        ];
        foreach (languages() as $lang) {
            $lang_attributes=[
                'name_'.$lang->local=> $field[$lang->local]['name'] ?? __('partners.name'),
//                'slug_'.$lang->local=>  $field[$lang->local]['slug'] ?? __('partners.slug'),
//                'keywords_'.$lang->local=> $field[$lang->local]['keywords'] ?? __('partners.keywords'),
//                'meta_description_'.$lang->local=> $field[$lang->local]['meta_description'] ?? __('partners.meta_description'),
//                'description_'.$lang->local=> $field[$lang->local]['description'] ?? __('partners.description'),
            ];
            $attributes= array_merge($attributes, $lang_attributes);
        }
        return $attributes;
    }
    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests

        if(Request::ajax()){
            $errors = $validator->errors()->first();
            throw new HttpResponseException(response()->json(['errors' => $errors]));
        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
