<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VisitorMessageReply extends Model
{
    protected $fillable = ['reply', 'visitor_email', 'user_id', 'visitor_message_id'];

    /**
     * Return message for multi replies
     * @return BelongsTo
     */
    public function visitorMessage() :BelongsTo
    {
        return $this->belongsTo(VisitorMessage::class);
    }
}
