<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePhotoCategoryDescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('photo_category_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name',100)->nullable();
            $table->string('slug',100)->nullable();

            $table->unsignedBigInteger('photo_category_id')->index('pc_id');
            $table->unsignedBigInteger('language_id')->index();
            $table->foreign('photo_category_id')->references('id')->on('photo_categories')->cascadeOnDelete();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('photo_category_descriptions');
    }
}
