<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCountryDescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('country_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name', 50);

            $table->unsignedBigInteger('country_id');
            $table->unsignedBigInteger('language_id');

            $table->foreign('country_id')->references('id')->on('countries')->onDelete('cascade');

            $table->index(['country_id', 'language_id']);
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('country_descriptions');
    }
}
