<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDirectorDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('director_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100)->nullable();
            $table->string('specialist', 100)->nullable();
//            $table->longText('description')->nullable();

            $table->unsignedBigInteger('director_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('director_id')->references('id')->on('directors')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('director_descriptions');
    }
}
