<?php

use Illuminate\Database\Seeder;

class BannerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $categories = [1,2,3];

        foreach ($categories as $category) {
            factory(\App\Banner::class)->create(['category_id' => $category]);
        }

        foreach (\App\Banner::cursor() as $banner) {
            foreach (languages() as $language){
                factory(\App\BannerDescription::class)->create([
                    'banner_id' => $banner->id,
                    'language_id' => $language->id,
                ]);
            }
        }

    }
}
