<?php

use Illuminate\Database\Seeder;

class CareerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/nursing-1.png',
            'assets/web/images/news-2.jpg',
            'assets/web/images/news-4.jpg',
        ];

        foreach ($images as $image) {
            factory(\App\Career::class)->create(['image' => $image]);
        }

        foreach (languages() as $language) {
            foreach (\App\Career::cursor() as $career) {
                factory(\App\CareerDescription::class)->create([
                    'career_id' => $career->id,
                    'language_id' => $language->id,
                ]);
            }

        }
    }

}
