<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/categ-1.png',
            'assets/web/images/categ-2.png',
        ];

        foreach ($images as $image) {
            factory(\App\Category::class)->create(['image' => $image]);
        }

        foreach (languages() as $language) {
            factory(\App\CategoryDescription::class)->create([
                'name' => 'Ice cream',
                'category_id' => 1,
                'language_id' => $language->id
            ]);

            factory(\App\CategoryDescription::class)->create([
                'name' => 'MilkShakes',
                'category_id' => 2,
                'language_id' => $language->id
            ]);
        }



    }
}
