<?php

use Illuminate\Database\Seeder;

class ConferenceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/news-4.jpg',
            'assets/web/images/news-2.jpg',
            'assets/web/images/news-1.jpg',
        ];
        foreach ($images as $image) {
            factory(\App\Conference::class, 2)->create(['image' => $image]);
        }

        foreach (languages() as $language) {
            foreach (\App\Conference::cursor() as $conference) {
                factory(\App\ConferenceDescription::class)->create([
                    'conference_id' => $conference->id,
                    'language_id' => $language->id,
                ]);
            }

        }
    }
}
