<?php

use Illuminate\Database\Seeder;
use App\Module;
class ModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Module::create(['name' => 'Nationalities', 'path' => 'countries', 'meta' =>
            [
                'module_name' => ['ar' => 'الجنسيات', 'en' => 'Nationalities'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة جنسية جديدة',
                        'edit' => 'تعديل الجنسية',
                        'name' => 'إسم الجنسية',
                        'code' => 'كود الدولة',
                    ],
                    'en' => [
                        'new' => 'Add new nationality',
                        'edit' => 'Edit nationality',
                        'name' => 'Country name',
                        'code' => 'Country code',
                    ],
                ],

            ]
        ]); // Countries
        Module::create(['name' => 'Educations', 'path' => 'educations', 'meta' =>
            [
                'module_name' => ['ar' => 'المستوي التعليمي', 'en' => 'Educations'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة مستوى تعليمي جديد',
                        'edit' => 'تعديل المستوى التعليمي',
                        'name' => 'إسم المستوى التعليمي',
                    ],
                    'en' => [
                        'new' => 'Add new education',
                        'edit' => 'Edit education',
                        'name' => 'Education name',
                    ],
                ],

            ]
        ]); // Educations
        Module::create(['name' => 'Directors', 'path' => 'directors', 'meta' =>
            [
                'module_name' => ['ar' => 'أعضاء مجلس الإدارة', 'en' => 'Directors'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة مدير جديد',
                        'edit' => 'تعديل مدير',
                        'name' => 'الإسم الكامل',
                        'specialist' => 'التخصص',
                        'description' => 'الوصف',
                        'image' => 'الصورة',

                    ],
                    'en' => [
                        'new' => 'Add New director',
                        'edit' => 'Edit director',
                        'name' => 'Name',
                        'specialist' => 'Specialist',
                        'description' => 'Description',
                        'image' => 'Image',
                    ],
                ],

            ]
        ]); // Directors
        Module::create(['name' => 'Doctors', 'path' => 'doctors', 'meta' =>
            [
                'module_name' => ['ar' => 'الأطباء', 'en' => 'Doctors'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة طبيب جديد',
                        'edit' => 'تعديل طبيب',
                        'name' => 'الإسم الكامل',
                        'specialist' => 'التخصص',
                        'certifications' => 'الشهادات',
                        'trainings' => 'التدريب',
                        'experiences' => 'الخبرات',
                        'researches' => 'الأبحاث',
                        'professional_memberships' => 'العضويات المهنية',
                        'details' => 'التفاصيل',
                        'show_in_chairman' => 'إظهار في صفحة الرئيس التنفيذي ',
                        'show_in_home' => 'إظهار في الصفحة الرئيسية ',
                        'show_in_offers' => 'إظهار في صفحة العروض ',
                        'category_id' => 'التصنيف',
                        'discount_percentage' => 'نسبة الخصم',
                        'facebook' => 'فيس بوك',
                        'twitter' => 'تويتر',
                        'instagram' => 'إنستجرام',
                        'linkedin' => 'لينكدإن',
                        'okadoc_url' => 'رابط أوكادوك',
                        'image' => 'الصورة',

                    ],
                    'en' => [
                        'new' => 'Add New doctor',
                        'edit' => 'Edit doctor',
                        'name' => 'Full name',
                        'specialist' => 'Specialist',
                        'certifications' => 'Certifications',
                        'trainings' => 'Trainings',
                        'experiences' => 'Experiences',
                        'researches' => 'Researches',
                        'professional_memberships' => 'Professional memberships',
                        'details' => 'Details',
                        'show_in_chairman' => 'Show in chairman page',
                        'show_in_home' => 'Show in home page',
                        'show_in_offers' => 'Show in offers page',
                        'category_id' => 'Category',
                        'discount_percentage' => 'Discount percentage',
                        'facebook' => 'Facebook',
                        'twitter' => 'Twitter',
                        'instagram' => 'Instagram',
                        'linkedin' => 'Linkedin',
                        'okadoc_url' => 'Okadoc url',
                        'image' => 'Image',
                    ],
                ],

            ]
        ]); // Doctors
        Module::create(['name' => 'Services', 'path' => 'services', 'meta' =>
            [
                'module_name' => ['ar' => 'الخدمات', 'en' => 'Services'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة خدمة جديد',
                        'edit' => 'تعديل خدمة',
                        'name' => 'إسم الخدمة',
                        'description' => 'تفاصيل الخدمة',
                        'doctor_ids' => 'أسماء الطبيب',
                        'image' => 'الصورة',

                    ],
                    'en' => [
                        'new' => 'Add New service',
                        'edit' => 'Edit service',
                        'name' => 'Service name',
                        'description' => 'Service description',
                        'doctor_ids' => 'Doctor names',
                        'image' => 'Image',
                    ],
                ],

            ]
        ]); // Services
        Module::create(['name' => 'Conferences', 'path' => 'conferences', 'meta' =>
            [
                'module_name' => ['ar' => 'المؤتمرات', 'en' => 'Conferences'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة مؤتمر جديد',
                        'edit' => 'تعديل مؤتمر',
                        'title' => 'عنوان المؤتمر',
                        'description' => 'تفاصيل المؤتمر',
                        'start_date' => 'تاريخ بداية المؤتمر',
                        'end_date' => 'تاريخ نهاية المؤتمر',
                        'image' => 'الصورة',
                        'files' => 'الملفات',

                    ],
                    'en' => [
                        'new' => 'Add New conference',
                        'edit' => 'Edit conference',
                        'title' => 'Conference title',
                        'description' => 'Conference description',
                        'start_date' => 'Conference start date',
                        'end_date' => 'Conference end date',
                        'image' => 'Image',
                        'files' => 'Files',
                    ],
                ],

            ]
        ]); // Conferences
        Module::create(['name' => 'Jobs', 'path' => 'careers', 'meta' =>
            [
                'module_name' => ['ar' => 'الوظائف', 'en' => 'Jobs'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة وظيفة جديد',
                        'edit' => 'تعديل وظيفة',
                        'name' => 'إسم الوظيفة',
                        'image' => 'الصورة',
                        'description' => 'تفاصيل الوظيفة',
                        'service_id' => 'إسم التخصص',

                    ],
                    'en' => [
                        'new' => 'Add New job',
                        'edit' => 'Edit job',
                        'name' => 'Job name',
                        'image' => 'Image',
                        'description' => 'Job description',
                        'service_id' => 'Specialty name',

                    ],
                ],

            ]
        ]); // Careers
        Module::create(['name' => 'Slider', 'path' => 'sliders', 'meta' =>
            [
                'module_name' => ['ar' => 'السلايدر', 'en' => 'Slider'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة سلايد جديدة',
                        'edit' => 'تعديل سلايد',
                        'title' => 'عنوان الاسلايد',
//                        'url' => 'رابط الاسلايد',
//                        'main_category_id' => 'التصنيف الرئيسي',
//                        'sub_category_id' => 'التصنيف الفرعي',
//                        'status' => 'الحالة',
                        'description' => 'الوصف',
//                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add new slider',
                        'edit' => 'Edit slider',
                        'title' => 'Slide title',
//                        'url' => 'Slider url',
//                        'main_category_id' => 'Main category',
//                        'sub_category_id' => 'Sub category',
//                        'status' => 'Status',
                        'description' => 'Description',
//                        'image' => 'Image',

                    ],
                ],
            ]
        ]); // Sliders
        Module::create(['name' => 'Galleries', 'path' => 'galleries', 'meta' =>
            [
                'module_name' => ['ar' => 'المعرض', 'en' => 'Galleries'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة معرض جديدة',
                        'edit' => 'تعديل معرض',
                        'type' => 'نوع المعرض',
                        'title' => 'عنوان المعرض',
                        'image' => 'الصورة',
                        'video_url' => 'رابط الفيديو (يوتيوب)',
                    ],
                    'en' => [
                        'new' => 'Add new gallery',
                        'edit' => 'Edit gallery',
                        'type' => 'Gallery type',
                        'title' => 'Gallery title',
                        'image' => 'Image',
                        'video_url' => 'Video url (Youtube)',

                    ],
                ],
            ]
        ]); // Galleries
        Module::create(['name' => 'Banners', 'path' => 'banners', 'meta' =>
            [
                'module_name' => ['ar' => 'البنرات', 'en' => 'Banners'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة بانر جديدة',
                        'edit' => 'تعديل بانر',
                        'category_id' => 'التصنيف',
                        'title' => 'عنوان البانر',
                        'description' => 'وصف البانر',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add new banner',
                        'edit' => 'Edit banner',
                        'category_id' => 'Category',
                        'title' => 'Title',
                        'description' => 'Description',
                        'image' => 'Image',

                    ],
                ],
            ]
        ]); // Banners
        Module::create(['name' => 'Client opinions', 'path' => 'reviews', 'meta' =>
            [
                'module_name' => ['ar' => 'أراء العملاء', 'en' => 'Client opinions'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة رأي جديد',
                        'edit' => 'تعديل رأي',
                        'name' => 'إسم المستخدم',
                        'job_title' => 'المسمى الوظيفي',
                        'rate' => 'التقييم',
                        'review' => 'الرأي',
                        'image' => 'صورة',

                    ],
                    'en' => [
                        'new' => 'Add new review',
                        'edit' => 'Edit review',
                        'name' => 'User name',
                        'job_title' => 'Job title',
                        'rate' => 'Rate',
                        'review' => 'Review',
                        'image' => 'Image',

                    ],
                ],

            ]
        ]); // Client opinions
        Module::create(['name' => 'News', 'path' => 'articles', 'meta' =>
            [
                'module_name' => ['ar' => 'الأخبار', 'en' => 'News'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة خبر جديد',
                        'edit' => 'تعديل خبر',
                        'external_link' => 'رابط خارجي',
                        'local_link' => 'ملف محلي',
                        'title' => 'عنوان الخبر',
                        'slug' => 'URL Slug',
                        'keywords' => 'كلمات تنشيط محرك البحث',
                        'meta_description' => 'الكلمات الوصفية',
                        'video_type' => 'نوع الفيديو',
                        'video_url' => 'رابط الفيديو',
                        'description' => 'الوصف',
                        'video' => 'الفيديو',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New news',
                        'edit' => 'Edit news',
                        'external_link' => 'External Link',
                        'local_link' => 'Local Storage',
                        'title' => 'News title',
                        'slug' => 'URL Slug',
                        'keywords' => 'SEO keywords',
                        'meta_description' => 'Meta Description',
                        'video_type' => 'Video Type',
                        'video_url' => 'Url',
                        'description' => 'Description',
                        'video' => 'Video',
                        'image' => 'Image',
                    ],
                ]
            ]
        ]); // Articles
        Module::create(['name' => 'Partners', 'path' => 'partners', 'meta' =>
            [
                'module_name' => ['ar' => 'شركاء النجاح', 'en' => 'Partners'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة شريك جديد',
                        'edit' => 'تعديل شريك',
                        'name' => 'الإسم',
                        'type' => 'النوع',
                        'image' => 'الصورة',
                        'url' => 'الرابط',
//                        'title' => 'العنوان',
//                        'description' => 'الوصف',
                    ],
                    'en' => [
                        'new' => 'Add New partner',
                        'edit' => 'Edit partner',
                        'name' => 'Name',
                        'type' => 'Type',
                        'image' => 'Image',
                        'url' => 'url',
//                        'title' => 'Title',
//                        'description' => 'Description',
                    ],
                ],

            ]
        ]); // Partners
        Module::create(['name' => 'Visitor Messages', 'path' => 'visitorMessages', 'meta' =>
            [
                'module_name' => ['ar' => 'رسائل الزوار', 'en' => 'Visitor Messages'],
                'fields' => [
                    'ar' => [
                        'new' => 'رد جديد',
                        'name' => 'الإسم الكامل',
                        'visitor_email' => 'البريد الإلكتروني للزائر',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'الجوال',
                        'subject' => 'موضوع الرسالة',
                        'message' => 'محتوى الرسالة',
                        'reply' => 'الرد على الرسالة',
                        'send_to' => 'إرسال إلى',
                    ],
                    'en' => [
                        'new' => 'Reply New Message',
                        'name' => 'Name',
                        'visitor_email' => 'E-mail',
                        'email' => 'E-mail',
                        'phone' => 'Phone',
                        'subject' => 'Subject',
                        'message' => 'Message',
                        'reply' => 'Reply to message',
                        'send_to' => 'Send to',
                    ],
                ],
            ]
        ]); // Visitor Messages
        Module::create(['name' => 'Admins', 'path' => 'users', 'meta' =>
            [
                'module_name' => ['ar' => 'المشرفين', 'en' => 'Admins'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة مشرف جديد',
                        'edit' => 'تعديل مشرف',
                        'title' => 'الإسم',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'رقم الجوال',
                        'photo' => 'صورة البروفايل',
                        'password' => 'كلمة المرور',
                        'password_confirmation' => 'تأكيد كلمة المرور',
                        'modules' => 'الموديولات',
                    ],
                    'en' => [
                        'new' => 'Add New admin',
                        'edit' => 'Edit admin',
                        'name' => 'Name',
                        'email' => 'Email',
                        'phone' => 'Phone',
                        'photo' => 'Photo',
                        'password' => 'Password',
                        'password_confirmation' => 'Password Confirmation',
                        'modules' => 'Modules',
                    ],
                ],

            ]
        ]); // Users
        Module::create(['name' => 'Work hours', 'path' => 'workHours', 'meta' =>
            [
                'module_name' => ['ar' => 'مواعيد العمل', 'en' => 'Work hours'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة ميعاد جديد',
                        'edit' => 'تعديل ميعاد',
                        'status' => 'الحالة',
                        'week_day' => 'اليوم',
                        'time_from' => 'الوقت من',
                        'time_to' => 'الوقت إلى',

                    ],
                    'en' => [
                        'new' => 'Add New time',
                        'edit' => 'Edit time',
                        'status' => 'Status',
                        'week_day' => 'Day of week',
                        'time_from' => 'Time from',
                        'time_to' => 'Time to',

                    ],
                ],

            ]
        ]); // Work Hours
        Module::create(['name' => 'Jobs applications', 'path' => 'careerApplications', 'meta' =>
            [
                'module_name' => ['ar' => 'تقديمات الوظائف', 'en' => 'Jobs applications'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة تقديم جديد',
                        'edit' => 'تفاصيل التقديم',
                        'name' => 'الإسم الكامل',
                        'career_id' => 'إسم الوظيفة المقدم عليها',
                        'country_id' => 'الجنسية',
                        'education_id' => 'المؤهل الدراسي',
                        'service_id' => 'التخصص',
                        'submission_date' => 'تاريخ التقديم',
                        'phone' => 'الجوال',
                        'birth_date' => 'تاريخ الميلاد',
                        'address' => 'العنوان',
                        'cv' => 'السيرة الذاتية',

                    ],
                    'en' => [
                        'new' => 'Add New job',
                        'edit' => 'Job details',
                        'name' => 'Full name',
                        'career_id' => 'Name of the position applied for',
                        'country_id' => 'Nationality',
                        'education_id' => 'Educational Qualification',
                        'service_id' => 'Specialization',
                        'submission_date' => 'Submission date',
                        'phone' => 'Phone',
                        'birth_date' => 'Birth date',
                        'address' => 'Address',
                        'cv' => 'CV',

                    ],
                ],

            ]
        ]); // Careers Applications
        Module::create(['name' => 'Pages', 'path' => 'pages', 'meta' =>
            [
                'module_name' => ['ar' => 'الصفحات', 'en' => 'Pages'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة صفحة جديدة',
                        'edit' => 'تعديل صفحة',
                        'title' => 'العنوان',
                        'title_2' => 'العنوان الثاني',
                        'slug' => 'URL Slug',
                        'keywords' => 'كلمات تنشيط محرك البحث',
                        'meta_description' => 'الكلمات الوصفية',
                        'description' => 'الوصف',
                        'description_2' => 'الوصف الثاني',
                        'image' => 'الصورة',
                        'images' => 'الصور',
                    ],
                    'en' => [
                        'new' => 'Add New Page',
                        'edit' => 'Edit Pages',
                        'title' => 'Title',
                        'title_2' => 'Second title',
                        'slug' => 'URL Slug',
                        'keywords' => 'SEO keywords',
                        'meta_description' => 'Meta Description',
                        'description' => 'Description',
                        'description_2' => 'Second description',
                        'image' => 'Image',
                        'images' => 'Images',
                    ],
                ],

            ]
        ]); // Pages
        Module::create(['name' => 'Settings', 'path' => 'settings', 'meta' =>
            [
                'module_name' => ['ar' => 'الإعدادت', 'en' => 'Settings'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة أعدادت',
                        'edit' => 'تعديل الإعدادت',
                        'website_disable' => 'تعطيل الموقع',
                        'disable_dashboard' => 'تعطيل لوحة التحكم',
                        'website_name' => 'اسم الموقع',
                        'Keywords' => 'الكلمات الدليلية',
                        'meta_description' => 'الكلمات الوصفية',
                        'site_email' => 'بريد الموقع',
                        'site_address' => 'عنوان الموقع',
                        'site_phone' => 'جوال الموقع',
                        'site_tel' => 'هاتف الموقع',
                        'mail_driver' => 'Mail Driver(SMTP)',
                        'mail_host' => 'Mail Host (smtp.example.com)',
                        'mail_port' => 'Mail Port (2525)',
                        'mail_username' => 'Mail Username(username@example.cm)',
                        'mail_password' => 'Mail password',
                        'mail_encryption' => 'Mail Encryption(tls)',
                        'mail_from_address' => 'Mail From address(info@example.com)',
                        'mail_from_name' => 'Mail From Name(Example)',
                        'website_logo' => 'لوجو الموقع',
                        'site_map' => 'خريطة الموقع',
                        'facebook' => 'فيس بوك',
                        'twitter' => 'تويتر',
                        'instagram' => 'إنستجرام',
                        'linkedin' => 'لنكدإن',
                        'telegram' => 'تليجرام',
                        'tiktok' => 'تيك توك',
                        'snapchat' => 'سناب شات',
                        'whatsapp' => 'واتساب',
                        'special_num_1_value' => 'قيمة أرقام مميزة (الأولى)',
                        'special_num_2_value' => 'قيمة أرقام مميزة (الثانية)',
                        'special_num_3_value' => 'قيمة أرقام مميزة (الثالثة)',
                        'special_num_4_value' => 'قيمة أرقام مميزة (الرابعة)',
                        'special_num_1_title' => 'عنوان أرقام مميزة (الأولى)',
                        'special_num_2_title' => 'عنوان أرقام مميزة (الثانية)',
                        'special_num_3_title' => 'عنوان أرقام مميزة (الثالثة)',
                        'special_num_4_title' => 'عنوان أرقام مميزة (الرابعة)',
                    ],
                    'en' => [
                        'new' => 'Add Settings',
                        'edit' => 'Edit Settings',
                        'website_disable' => 'Website Disabled',
                        'disable_dashboard' => 'Dashboard Disabled',
                        'website_name' => 'Website Name',
                        'Keywords' => 'Keywords',
                        'meta_description' => 'Meta Description',
                        'site_email' => 'Website Email',
                        'site_address' => 'Website Address',
                        'site_phone' => 'Website Phone',
                        'site_tel' => 'Website tel',
                        'mail_driver' => 'Mail Driver(SMTP)',
                        'mail_host' => 'Mail Host (smtp.example.com)',
                        'mail_port' => 'Mail Port (2525)',
                        'mail_username' => 'Mail Username(username@example.cm)',
                        'mail_password' => 'Mail password',
                        'mail_encryption' => 'Mail Encryption(tls)',
                        'mail_from_address' => 'Mail From address(info@example.com)',
                        'mail_from_name' => 'Mail From Name(Example)',
                        'website_logo' => 'Website Logo',
                        'site_map' => 'Site map',
                        'facebook' => 'Facebook',
                        'twitter' => 'Twitter',
                        'instagram' => 'Instagram',
                        'linkedin' => 'Linkedin',
                        'telegram' => 'Telegram',
                        'tiktok' => 'TikTok',
                        'snapchat' => 'Snapchat',
                        'whatsapp' => 'Wahtsapp',
                        'special_num_1_value' => 'Distinguished numbers value (first)',
                        'special_num_2_value' => 'Distinguished Numbers Value (Second)',
                        'special_num_3_value' => 'Distinguished Numbers Value (Third)',
                        'special_num_4_value' => 'Distinguished Numbers Value (Fourth)',
                        'special_num_1_title' => 'Title of distinct numbers (first)',
                        'special_num_2_title' => 'Title of distinct numbers (second)',
                        'special_num_3_title' => 'Title of distinct numbers (Third)',
                        'special_num_4_title' => 'Title of distinct numbers (Fourth)',
                    ],
                ],

            ]
        ]); // Settings
    }
}
