<?php

use Illuminate\Database\Seeder;
use App\Module;
class OldModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Module::create(['name' => 'Sections', 'path' => 'categories', 'meta' =>
            [
                'module_name' => ['ar' => 'الأقسام', 'en' => 'Sections'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة قسم جديد',
                        'edit' => 'تعديل قسم',
                        'name' => 'الإسم',
                        'slug' => 'Slug',
                        'keywords' => 'الكلمات الدليلية',
                        'meta_description' => 'الكلمات الوصفية',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New section',
                        'edit' => 'Edit section',
                        'name' => 'Name',
                        'slug' => 'Slug',
                        'keywords' => 'Keywords',
                        'meta_description' => 'Meta Description',
                        'image' => 'Image',

                    ],
                ]
            ]
        ]); // Categories
        Module::create(['name' => 'Flavors types', 'path' => 'flavorTypes', 'meta' =>
            [
                'module_name' => ['ar' => 'أنواع النكهات', 'en' => 'Flavors types'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة نوع جديد',
                        'edit' => 'تعديل نوع',
                        'name' => 'الإسم',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New type',
                        'edit' => 'Edit type',
                        'name' => 'Name',
                        'image' => 'Image',
                    ],
                ]
            ]
        ]); // Flavors types
        Module::create(['name' => 'Flavors', 'path' => 'articles', 'meta' =>
            [
                'module_name' => ['ar' => 'النكهات', 'en' => 'Flavors'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة نكهة جديد',
                        'edit' => 'تعديل نكهة',
                        'external_link' => 'رابط خارجي',
                        'local_link' => 'ملف محلي',
                        'flavor_type_id' => 'نوع النكهة',
                        'name' => 'إسم النكهة',
                        'slug' => 'URL Slug',
                        'keywords' => 'كلمات تنشيط محرك البحث',
                        'meta_description' => 'الكلمات الوصفية',
                        'video_type' => 'نوع الفيديو',
                        'video_url' => 'رابط الفيديو',
                        'description' => 'الوصف',
                        'video' => 'الفيديو',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New Flavor',
                        'edit' => 'Edit Flavor',
                        'external_link' => 'External Link',
                        'local_link' => 'Local Storage',
                        'flavor_type_id' => 'Flavor type',
                        'name' => 'Flavor name',
                        'slug' => 'URL Slug',
                        'keywords' => 'SEO keywords',
                        'meta_description' => 'Meta Description',
                        'video_type' => 'Video Type',
                        'video_url' => 'Url',
                        'description' => 'Description',
                        'video' => 'Video',
                        'image' => 'Image',
                    ],
                ]
            ]
        ]); // Articles => Flavors
        Module::create(['name' => 'Video Categories', 'path' => 'videoCategories', 'meta' =>
            [
                'module_name' => ['ar' => 'أقسام الفيديوهات', 'en' => 'Video Categories'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة قسم جديد',
                        'edit' => 'تعديل قسم',
                        'name' => 'الإسم',
                        'slug' => 'URL Slug',
                        'keywords' => 'كلمات تنشيط محرك البحث',
                        'meta_description' => 'الكلمات الوصفية',
                    ],
                    'en' => [
                        'new' => 'Add New Video Category',
                        'edit' => 'Edit Video Category',
                        'name' => 'Name',
                        'slug' => 'URL Slug',
                        'keywords' => 'SEO keywords',
                        'meta_description' => 'Meta Description',
                    ]
                ]
            ]
        ]); // Video Categories
        Module::create(['name' => 'Videos', 'path' => 'videos', 'meta' =>
            [
                'module_name' => ['ar' => 'الفيديوهات', 'en' => 'Videos'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة فيديو جديد',
                        'edit' => 'تعديل الفيديو',
                        'external_link' => 'رابط خارجي',
                        'local_link' => 'ملف محلي',
                        'video_category_id' => 'القسم',
                        'title' => 'الإسم',
                        'type' => 'نوع الفيديو',
                        'video_url' => 'رابط الفيديو',
                        'video' => 'الفيديو',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New Video',
                        'edit' => 'Edit Video',
                        'external_link' => 'External link',
                        'local_link' => 'Local Storage',
                        'video_category_id' => 'Category',
                        'title' => 'Name',
                        'type' => 'Video Type',
                        'video_url' => 'URL',
                        'video' => 'Video',
                        'image' => 'Image',
                    ],
                ],

            ]
        ]); // Videos
        Module::create(['name' => 'Delivery Companies', 'path' => 'photoCategories', 'meta' =>
            [
                'module_name' => ['ar' => 'شركات التوصيل', 'en' => 'Delivery Companies'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة شركة جديد',
                        'edit' => 'تعديل الشركة',
                        'gallery_title' => 'عنوان الشركة',
                        'name' => 'الإسم',
                        'slug' => 'Url Slug',
                        'image_title' => 'عنوان الصورة',
                        'images' => 'صور الشركة',
                    ],
                    'en' => [
                        'new' => 'Add New company',
                        'edit' => 'Edit company',
                        'gallery_title' => 'Company Title',
                        'name' => 'Name',
                        'slug' => 'Url Slug',
                        'image_title' => 'Image Title',
                        'images' => 'Company Photos',
                    ],
                ],
            ]
        ]); // Photos Galleries => Delivery Companies
        Module::create(['name' => 'Web-sites Galleries', 'path' => 'websiteCategories', 'meta' =>
            [
                'module_name' => ['ar' => 'ألبومات الموقع', 'en' => 'Websites Galleries'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة البوم جديد',
                        'edit' => 'تعديل الألبوم',
                        'name' => 'الإسم',
                        'slug' => 'URL Slug',
                        'image_title' => 'عنوان الصورة',
                        'image_url' => 'رابط الصورة',
                        'new_item' => 'إضافة صورة',
                        'images' => 'صور الألبوم',
                    ],
                    'en' => [
                        'new' => 'Add New Website Gallery',
                        'edit' => 'Edit Website Gallery',
                        'name' => 'Name',
                        'slug' => 'URL Slug',
                        'image_title' => 'title',
                        'image_url' => 'Url',
                        'new_item' => 'Add New Item',
                        'images' => 'Album Photos',
                    ],

                ],

            ]
        ]); // Web-sites Galleries
        Module::create(['name' => 'Addresses', 'path' => 'addresses', 'meta' =>
            [
                'module_name' => ['ar' => 'العناوين', 'en' => 'Addresses'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة عنوان جديدة',
                        'edit' => 'تعديل عنوان',
                        'name' => 'إسم العنوان',
                        'map_url' => 'رابط خريطة العنوان',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'الجوال',
                    ],
                    'en' => [
                        'new' => 'Add New address',
                        'edit' => 'Edit address',
                        'name' => 'Name',
                        'map_url' => 'Map url',
                        'email' => 'E-mail',
                        'phone' => 'Phone',
                    ],
                ],

            ]
        ]); // Addresses
        Module::create(['name' => 'Slider', 'path' => 'sliders', 'meta' =>
            [
                'module_name' => ['ar' => 'السلايدر', 'en' => 'Slider'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة سلايد جديدة',
                        'edit' => 'تعديل سلايد',
                        'show_in' => 'عرض في',
                        'title' => 'عنوان الاسلايد',
//                        'url' => 'رابط الاسلايد',
//                        'main_category_id' => 'التصنيف الرئيسي',
//                        'sub_category_id' => 'التصنيف الفرعي',
//                        'status' => 'الحالة',
                        'description' => 'الوصف',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add new slider',
                        'edit' => 'Edit slider',
                        'show_in' => 'Show in',
                        'title' => 'Slide title',
//                        'url' => 'Slider url',
//                        'main_category_id' => 'Main category',
//                        'sub_category_id' => 'Sub category',
//                        'status' => 'Status',
                        'description' => 'Description',
                        'image' => 'Image',

                    ],
                ],
            ]
        ]); // Sliders
        Module::create(['name' => 'Pages', 'path' => 'pages', 'meta' =>
            [
                'module_name' => ['ar' => 'الصفحات', 'en' => 'Pages'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة صفحة جديدة',
                        'edit' => 'تعديل صفحة',
                        'title' => 'العنوان',
                        'slug' => 'URL Slug',
                        'keywords' => 'كلمات تنشيط محرك البحث',
                        'meta_description' => 'الكلمات الوصفية',
                        'description' => 'الوصف',
                        'image' => 'الصورة',
                    ],
                    'en' => [
                        'new' => 'Add New Page',
                        'edit' => 'Edit Pages',
                        'title' => 'Title',
                        'slug' => 'URL Slug',
                        'keywords' => 'SEO keywords',
                        'meta_description' => 'Meta Description',
                        'description' => 'Description',
                        'image' => 'Image',
                    ],
                ],

            ]
        ]); // Pages
        Module::create(['name' => 'News letters', 'path' => 'newsletters', 'meta' =>
            [
                'module_name' => ['ar' => 'الرسائل الإخبارية', 'en' => 'News letters'],
                'fields' => [
                    'ar' => [
                        'new' => 'قائمة البريد',
                        'email' => 'إرسال إلى',
                        'subject' => 'موضوع الرسالة الإخبارية',
                        'message' => 'محتوى الرسالة',
                        'categories' => 'الأقسام',
                    ],
                    'en' => [
                        'new' => 'Mail list',
                        'email' => 'Send to',
                        'subject' => 'Subject of Newsletters',
                        'message' => 'Message of Newsletters',
                        'categories' => 'Select Categories',
                    ],
                ],

            ]
        ]); // News letters
        Module::create(['name' => 'Visitor Messages', 'path' => 'visitorMessages', 'meta' =>
            [
                'module_name' => ['ar' => 'رسائل الزوار', 'en' => 'Visitor Messages'],
                'fields' => [
                    'ar' => [
                        'new' => 'رد جديد',
                        'name' => 'الإسم الكامل',
                        'visitor_email' => 'البريد الإلكتروني للزائر',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'الجوال',
                        'subject' => 'موضوع الرسالة',
                        'message' => 'محتوى الرسالة',
                        'reply' => 'الرد على الرسالة',
                        'send_to' => 'إرسال إلى',
                    ],
                    'en' => [
                        'new' => 'Reply New Message',
                        'name' => 'Name',
                        'visitor_email' => 'E-mail',
                        'email' => 'E-mail',
                        'phone' => 'Phone',
                        'subject' => 'Subject',
                        'message' => 'Message',
                        'reply' => 'Reply to message',
                        'send_to' => 'Send to',
                    ],
                ],
            ]
        ]); // Visitor Messages
        Module::create(['name' => 'Admins', 'path' => 'users', 'meta' =>
            [
                'module_name' => ['ar' => 'المشرفين', 'en' => 'Admins'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة مشرف جديد',
                        'edit' => 'تعديل مشرف',
                        'name' => 'الإسم',
                        'email' => 'البريد الإلكتروني',
                        'phone' => 'رقم الجوال',
                        'photo' => 'صورة البروفايل',
                        'password' => 'كلمة المرور',
                        'password_confirmation' => 'تأكيد كلمة المرور',
                        'modules' => 'الموديولات',
                    ],
                    'en' => [
                        'new' => 'Add New admin',
                        'edit' => 'Edit admin',
                        'name' => 'Name',
                        'email' => 'Email',
                        'phone' => 'Phone',
                        'photo' => 'Photo',
                        'password' => 'Password',
                        'password_confirmation' => 'Password Confirmation',
                        'modules' => 'Modules',
                    ],
                ],

            ]
        ]); // Users
        Module::create(['name' => 'Settings', 'path' => 'settings', 'meta' =>
            [
                'module_name' => ['ar' => 'الإعدادت', 'en' => 'Settings'],
                'fields' => [
                    'ar' => [
                        'new' => 'إضافة أعدادت',
                        'edit' => 'تعديل الإعدادت',
                        'website_disable' => 'تعطيل الموقع',
                        'dashboard_disable' => 'تعطيل لوحة التحكم',
                        'website_name' => 'اسم الموقع',
                        'Keywords' => 'الكلمات الدليلية',
                        'meta_description' => 'الكلمات الوصفية',
                        'site_email' => 'بريد الموقع',
                        'site_address' => 'عنوان الموقع',
                        'site_phone' => 'جوال الموقع',
                        'mail_driver' => 'Mail Driver(SMTP)',
                        'mail_host' => 'Mail Host (smtp.example.com)',
                        'mail_port' => 'Mail Port (2525)',
                        'mail_username' => 'Mail Username(username@example.cm)',
                        'mail_password' => 'Mail password',
                        'mail_encryption' => 'Mail Encryption(tls)',
                        'mail_from_address' => 'Mail From address(info@example.com)',
                        'mail_from_name' => 'Mail From Name(Example)',
                        'website_logo' => 'لوجو الموقع',
                        'site_map' => 'خريطة الموقع',
                        'facebook' => 'فيس بوك',
                        'twitter' => 'تويتر',
                        'instagram' => 'إنستجرام',
                        'linkedin' => 'لنكدإن',
                        'telegram' => 'تليجرام',
                        'tiktok' => 'تيك توك',
                        'snapchat' => 'سناب شات',
                        'special_num_1_value' => 'قيمة أرقام مميزة (الأولى)',
                        'special_num_2_value' => 'قيمة أرقام مميزة (الثانية)',
                        'special_num_1_title' => 'عنوان أرقام مميزة (الأولى)',
                        'special_num_2_title' => 'عنوان أرقام مميزة (الثانية)',
                    ],
                    'en' => [
                        'new' => 'Add Settings',
                        'edit' => 'Edit Settings',
                        'website_disable' => 'Website Disabled',
                        'dashboard_disable' => 'Dashboard Disabled',
                        'website_name' => 'Website Name',
                        'Keywords' => 'Keywords',
                        'meta_description' => 'Meta Description',
                        'site_email' => 'Website Email',
                        'site_address' => 'Website Address',
                        'site_phone' => 'Website Phone',
                        'mail_driver' => 'Mail Driver(SMTP)',
                        'mail_host' => 'Mail Host (smtp.example.com)',
                        'mail_port' => 'Mail Port (2525)',
                        'mail_username' => 'Mail Username(username@example.cm)',
                        'mail_password' => 'Mail password',
                        'mail_encryption' => 'Mail Encryption(tls)',
                        'mail_from_address' => 'Mail From address(info@example.com)',
                        'mail_from_name' => 'Mail From Name(Example)',
                        'website_logo' => 'Website Logo',
                        'site_map' => 'Site map',
                        'facebook' => 'Facebook',
                        'twitter' => 'Twitter',
                        'instagram' => 'Instagram',
                        'linkedin' => 'Linkedin',
                        'telegram' => 'Telegram',
                        'tiktok' => 'TikTok',
                        'snapchat' => 'Snapchat',
                        'special_num_1_value' => 'Distinguished numbers value (first)',
                        'special_num_2_value' => 'Distinguished Numbers Value (Second)',
                        'special_num_1_title' => 'Title of distinct numbers (first)',
                        'special_num_2_title' => 'Title of distinct numbers (second)',
                    ],
                ],

            ]
        ]); // Settings


        Module::whereIn('path', [
            'videoCategories',
            'videos',
            'newsletters',
            'websiteCategories',
        ])->update(['deleted_at' => now()]);
    }
}
