<?php

use Illuminate\Database\Seeder;

class PhotoCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $company = factory(\App\PhotoCategory::class)->create();



            foreach (languages() as $language) {
                factory(\App\PhotoCategoryDescription::class)->create([
                    'photo_category_id' => $company->id,
                    'language_id' => $language->id,
                ]);
            }

            $images = [
                'assets/web/images/delievery-1.png',
                'assets/web/images/delievery-2.png',
            ];

        foreach ($images as $image) {
            factory(\App\Photo::class)->create([
                'image' => $image,
                'photo_category_id' => $company->id,
            ]);
        }


    }
}
