@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_page_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($page ?? ''  && $page->id)
            @method('PUT')
        @endif
        @CSRF

        @foreach(languages() as $language)
        <div class="form-group col">
            <label>{{ meta('page_title', $language->local) ?? __('pages.page_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('page_title_'.$language->local) ? 'is-invalid' : '' }}" name="page_title_{{ $language->local }}" placeholder="{{ meta('page_title', $language->local) ?? __('pages.page_title') }}" value='{{ old("page_title_{$language->local}", $page[$language->local]->page_title ?? "") }}'/>
        </div>

        @if($page[$language->local]->title)
            <div class="form-group col">
                <label>{{ meta('title', $language->local) ?? __('pages.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('pages.title') }}" value='{{ old("title_{$language->local}", $page[$language->local]->title ?? "") }}'/>
            </div>
        @endif
        @if($page[$language->local]->title_2)
            <div class="form-group col">
                <label>{{ meta('title_2', $language->local) ?? __('pages.title_2') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_2_'.$language->local) ? 'is-invalid' : '' }}" name="title_2_{{ $language->local }}" placeholder="{{ meta('title_2', $language->local) ?? __('pages.title_2') }}" value='{{ old("title_2_{$language->local}", $page[$language->local]->title_2 ?? "") }}'/>
            </div>
        @endif
        @if($page[$language->local]->description)
            <div class="form-group col-lg-12">
                <label>{{ meta('description', $language->local) ?? __('pages.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <textarea rows="7" name="description_{{ $language->local }}" id="description_{{ $language->local }}" class="form-control my-editor  {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('pages.description') }}">{{ old("description_{$language->local}", $page[$language->local]->description ?? "") }}</textarea>
            </div>
        @endif

        @if($page[$language->local]->description_2)
            <div class="form-group col-lg-12">
                <label>{{ meta('description_2', $language->local) ?? __('pages.description_2') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <textarea rows="7" name="description_2_{{ $language->local }}" id="description_2_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_2_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description_2', $language->local) ?? __('pages.description_2') }}">{{ old("description_2_{$language->local}", $page[$language->local]->description_2 ?? "") }}</textarea>
            </div>
        @endif
        @endforeach
{{--            @if(in_array($page->id, [2,4]))--}}
{{--                <div class="property_container col-md-12">--}}
{{--                    @foreach($page->meta['titles']['ar'] as $propertyKey => $propertyName)--}}
{{--                        <div class="form-group col-lg-12 card deleted_property property_card">--}}
{{--                            <label>{{ __('pages.properties') }}</label>--}}
{{--                            <div class="row">--}}
{{--                                <div class="form-group col-md-12 d-flex justify-content-end">--}}
{{--                                    <a href="#" class="btn btn-danger delete_property mr-3"><i class="fa fa-times"></i></a>--}}
{{--                                </div>--}}
{{--                                <div class="form-group col-md-12">--}}
{{--                                    <input type="text" name="properties_ar[]" placeholder="{{__('pages.property_title') . ' (' . languages('ar')->name . ')'}}" class="form-control" value="{{$propertyName}}"/>--}}
{{--                                </div>--}}
{{--                                <div class="form-group col-md-12">--}}
{{--                                    <input type="text" name="properties_en[]" placeholder="{{__('pages.property_title') . ' (' . languages('en')->name . ')'}}" class="form-control" value="{{$page->meta['titles']['en'][$propertyKey]}}"/>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                    @endforeach--}}

{{--                </div>--}}
{{--                <div class="form-group col-lg-12">--}}
{{--                    <a href="#" class="btn btn-primary btn-block add_properties"><i class="fa fa-plus"></i> {{ __('pages.add_properties') }}</a>--}}
{{--                </div>--}}
{{--            @endif--}}

            {{--Start image container--}}
            @if($page->image)
                <div class="form-group col-lg-12">
                    <label>{{ meta('image', $lang) ?? __('pages.image') }} </label>
                    <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $page->image ?? "")}}"/>

                    <div class="photos image_main_photo {{ old('image', $page->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                        <div class="col-lg-6">
                            <div class="items">
                                <div class="img">
                                    <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".image_pick_button">
                                        <img src="{{asset(old('image', $page->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                    </a>
                                </div>
                                <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".image_main_photo" data-show=".image_pick_button"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <span class="input-group-btn image_pick_button {{ old('image', $page->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".image_main_photo" data-hide=".image_pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
            </span>
                </div>
            @endif
            {{--End image container--}}

            {{--Start video container--}}
            @if(is_array($page->meta) && count($page->meta))
                <div class="form-group col-lg-3">
                    <label>{{ meta('video', $lang) ?? __('pages.video') }} </label>
                    <input id="video_image_thumbnail" class="video_image_thumbnail" type="hidden" name="video" value="{{old("video", $page->meta['video'] ?? "")}}"/>

                    <div class="photos video_image_main_photo {{ old('image', $page->meta['video'] ?? '') ? ' wow fadeInUp' : 'hide' }}">
                        <div class="col-lg-12">
                            <div class="items">
                                <div class="img">
                                    <a href="#" id="lfm" data-input=".video_image_thumbnail" data-preview=".video_image_holder" class="lfm" data-hide=".video_image_pick_button">
                                        <img src="{{asset('assets/admin/images/video.png')}}"  id="video_image_holder" class="video_image_holder"/>
                                    </a>
                                </div>
                                <a href="#" class="showHide resetImage close" data-empty=".video_image_thumbnail" data-hide=".video_image_main_photo" data-show=".video_image_pick_button"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <span class="input-group-btn video_image_pick_button {{ old('video', $page->meta['video'] ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".video_image_thumbnail" data-preview=".video_image_holder" data-show=".video_image_main_photo" data-hide=".video_image_pick_button" class="lfm_file btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
            </span>
                </div>
            @endif
            {{--End video container--}}

            {{--Start image container--}}
            @if (is_array($page->images ?? []) && count($page->images ?? []))
            <div class="border-item photos col-md-12 other_image_container">
                <div class="row">
                    @foreach ($page->images as $image)
                        <div class="col-md-4">
                            <div class="items">
                                <div class="img">
                                    <a href="{{ asset($image ?? null)}}" data-fancybox="gallery"><img src="{{ asset($image ?? null)}}" alt=""></a>
                                </div>
                                <input type="hidden" name="images[]" value="{{ $image ?? null }}">
                                <a href="#" class="close"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    @endforeach
                </div>
                <div class="text-center">
                    <input id="other_image_thumbnail" class="other_image_thumbnail" type="hidden"/>
                    <div class="clearfix"></div>
                    <span id="add">
                    <a id="lfm" data-width="" data-cache="article_gallery" data-input=".other_image_thumbnail" data-preview="" data-show="" data-hide="" class="lfm add">
                        {{__('dashboard.add_new_item')}}
                    </a>
                </span>
                </div>
            </div>
            @endif
            {{--End image container--}}
        <div class="text-center mt-5 col-12">
            <button class="butn add_page_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{-- <script src="//cdn.tinymce.com/4/tinymce.min.js"></script> --}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imageTitle = "{{meta('image_title', $lang) ?? null}}",
            fileIcon = "{{asset('assets/admin/images/video.png')}}",
            inputName = null;
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/articles.js') }}"></script>

    <script>

        sendAjax('.add_page_button', '.add_page_form');

        $('.add_properties').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            let serviceDiv = `
                <div class="form-group col-lg-12 card deleted_property property_card">
                    <label>{{ __('pages.properties') }}</label>
                   <div class="row">
                   <div class="form-group col-md-12 d-flex justify-content-end">
                   <a href="#" class="btn btn-danger delete_property mr-3"><i class="fa fa-times"></i></a>
                   </div>
                    @foreach($languages as $language)
                        <div class="form-group col-md-12">
                            <input type="text" name="properties_{{$language->local}}[]" placeholder="{{__('pages.property_title') . ' ' . "($language->name)"}}" class="form-control" value=""/>
                        </div>
                    @endforeach

                </div>`;

            $('.property_container').append(serviceDiv);

        });

        $(document).on('click', '.delete_property', function (e) {
            e.preventDefault();
            $(this).parents('.deleted_property').remove();
        });


        $('body').on('DOMNodeInserted', '.properties_container', function(e) {
            if ($(e.target).find('.lfm')) {
                $('.lfm').filemanager('image', {prefix: route_prefix});
            }
        });

    </script>

@endsection



