@extends('web.layouts.container')
@section('css')
    <style>
        .partners-sec .partner_card{
            border: 1px solid #eee;
            border-radius: 10px;
            padding: 20px 10px;
            transition: .3s linear;
            border-radius: 15px;
            margin-bottom: 25px;
            height: calc(100% - 25px);
        }
        .partners-sec .partner_card .partner_logo {
            height: 80px;
            object-fit: contain;
            display: block;
            margin: 0 auto 20px auto;
        }
        .partners-sec .partner_card .partner_name {
            text-align: center;
            color: #666;
            transition: all .3s linear;
            font-weight: bold;
        }

        .partners-sec .partner_card:hover {
            border: 1px solid var(--primary);
            background-color: #f8f8f8;
        }
        .partners-sec .partner_card:hover .partner_name {
            color: var(--secondary);
        }

    </style>
@endsection
@section('content')
    <section class="partners-sec section">
        <div class="container">
            <div class="sec-head mb-5 col-lg-5">
                <h1 class="title color-dark fw-bold mb-4">
                    {{$pageTitle[0] ?? null}} <span class="color-primary">{{$pageTitle[1] ?? null}}</span>
                </h1>
            </div>
            <div class="row">
                @if(count($partners))
                    @foreach($partners as $partner)
                        <div class="col-lg-3">
                            <div class=" partner_card wow left_to_right_apperance">
                                <a target="_blank" href="{{$partner->url}}">
                                    <img src="{{asset($partner->image)}}" alt="" class="partner_logo"/>
                                    <h6 class="partner_name">{{$partner->name}}</h6>
                                </a>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
