<?php $__env->startSection('content'); ?>

<div class="form_box">
    <div class="form_head">
        <h3><?php echo e($head ?? ''); ?></h3>
    </div>
    <div class="form_body">
        <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
            <?php if($director ?? ''  && $director->id): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <?php echo csrf_field(); ?>

            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('name', $language->local) ?? __('directors.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('directors.name')); ?>" value='<?php echo e(old("name_{$language->local}", $director[$language->local]->name ?? "")); ?>'/>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('specialist', $language->local) ?? __('directors.specialist')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('specialist_'.$language->local) ? 'is-invalid' : ''); ?>" name="specialist_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('specialist', $language->local) ?? __('directors.specialist')); ?>" value='<?php echo e(old("specialist_{$language->local}", $director[$language->local]->specialist ?? "")); ?>'/>
                </div>




            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <div class="form-group col-lg-12 image_container">
                    <label><?php echo e(meta('image', $lang) ?? __('directors.image')); ?> </label>
                    <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $director->image ?? "")); ?>"/>

                    <div class="photos main_photo <?php echo e(old('image', $director->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                        <div class="col-md-4">
                            <div class="items">
                                <div class="img">
                                    <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                        <img src="<?php echo e(asset(old('image', $director->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                    </a>
                                </div>
                                <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <span class="input-group-btn pick_button <?php echo e(old('image', $director->image ?? '') ? 'hide' : ''); ?> ">
                    <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                    </a>
                 </span>
                </div>
                


            <div class="text-center mt-5 col-12">
                <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/procarecom/public_html/resources/views/admin/directors/form.blade.php ENDPATH**/ ?>