<section class="sidemenu">
    <div class="logo">
        <img src="<?php echo e(asset('/assets/admin/images/logo.png')); ?>" alt="">
    </div>
    <ul class="sidemenu-links">
        <li class="<?php echo e($activeMenu[""] ?? ''); ?>">
            <a href="<?php echo e(LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('dashboard'), [], true)); ?>"> <i class="bi bi-bar-chart"></i> <span><?php echo e(__('dashboard.dashboard')); ?></span></a>
        </li>
        <?php $__currentLoopData = $currentUserInfo->modules->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <?php
                /** @var $module */
                /** @var $lang */

                $moduleName = moduleName($module['path'], $lang);
                $moduleAddNew = metaFields($module['path'], 'add_new', $lang);
                $exceptedModules = ['settings', 'careerApplications', 'pages', 'workHours', 'banners'];
            ?>


            <?php if(in_array($module['path'], $exceptedModules)
                || (auth()->user()->role == 'sub_admin' && $module['path'] == 'users')): ?>

                <li class="<?php echo e($activeMenu[$module['path']] ?? ''); ?>">
                    <a href="<?php echo e(route("{$module['path']}.index")); ?>">

                        <i class="<?php echo e(__($module['path'].'.menuIcon') ?? 'bi bi-pen'); ?>"></i>
                        <span><?php echo e($moduleName ?? __($module['path'].'.head')); ?></span>

                    </a>
                </li>

            <?php else: ?>
                <li class="linkGroup  <?php echo e($activeMenu[$module['path']] ?? ''); ?>">
                    <a onclick="return false" href="#" class="linkItem-head"> <i class="<?php echo e(__($module['path'].'.menuIcon') ?? 'bi bi-pen'); ?>"></i> <span> <?php echo e($moduleName ??__($module['path'].'.head')); ?> </span></a>
                    <ul class="linkItem-body">
                        <li>
                            <a href='<?php echo e(route("{$module['path']}.index")); ?>'><?php echo e($moduleName ?? __($module['path'].'.head')); ?></a>
                        </li>
                        <li>
                            <?php if($module['path'] == 'newsletters'): ?>
                                <a href="<?php echo e(route("{$module['path']}.mailsList")); ?>"><?php echo e($moduleAddNew ?? __($module['path'].'.mail_list')); ?></a>
                            <?php else: ?>
                                <a href="<?php echo e(route("{$module['path']}.create")); ?>"><?php echo e($moduleAddNew ?? __($module['path'].'.new')); ?></a>
                            <?php endif; ?>
                        </li>

                    </ul>
                </li>
            <?php endif; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <li>
            <a data-toggle="modal" data-target="#logout" href="<?php echo e(route('admin_logout')); ?>" ><i class="bi bi-box-arrow-right"></i> <span> <?php echo e(__('dashboard.logout')); ?> </span></a>
        </li>
    </ul>
</section>





<!-- Modal -->
<div class="modal fade" id="logout" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('dashboard.logout_confirm')); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            
            <form id="logout-form-side" action="<?php echo e(route('admin_logout')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
            </form>
            
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('dashboard.close')); ?></button>
                <button onclick="document.getElementById('logout-form-side').submit()" type="button" class="btn btn-primary"><?php echo e(__('dashboard.logout')); ?></button>
            </div>
        </div>
    </div>
</div>


<?php /**PATH /home1/procarecom/public_html/resources/views/admin/layouts/menu.blade.php ENDPATH**/ ?>