@extends('web.layouts.container')

@section('content')
    <section class="ceo-pg conference_det section bg-babyBlue">
        <div class="container">
            <img src="{{asset($conference->image)}}" alt="" class="sec-img wow left_to_right_apperance"/>
            <div class="card-body col-lg-10 m-auto wow left_to_right_apperance">
                <h2 class="fw-bold color-dark mb-4">{{$conference->title}}</h2>
                <div class="dateTime d-flex">
                    <p class="date me-5">
                        <strong class="me-1"> {{__('conferences.start_date')}} :  </strong>
                        <i class="bi bi-calendar4-week me-2 color-dark"></i> {{date('d/M/Y ', strtotime($conference->start_date))}}
                    </p>
                    <p class="date me-5">
                        <strong class="me-1"> {{__('conferences.end_date')}} :  </strong>
                        <i class="bi bi-calendar4-week me-2 color-dark"></i> {{date('d/M/Y ', strtotime($conference->end_date))}}
                    </p>
                </div>
                <div class="desc_container">
                    {!! $conference->description !!}
                </div>
            </div>
            <div class="row col-lg-10 m-auto mt-5">
                <div class="col-12 mb-4">
                    <h3> {{__('conferences.other_belonging')}} </h3>
                </div>
                @if(is_array($conference->files) && count($conference->files))
                    @foreach($conference->files as $files)
                    <div class="col-lg-4">
                        <div class="file_card  wow fadeInUp overflow-visible">
                            <img src="{{asset('assets/web/images/icons/file.png')}}" alt="" class="icon"/>
                            <h5 class="title text-center color-secondary">{{__('main.file') . ' - ' . $loop->iteration}}</h5>
                            <a href="{{asset($files)}}" download class="butn white_butn">
                                <img src="{{asset('assets/web/images/icons/pdf.svg')}}" alt="" class="icon_pdf"/> {{__('main.download_file')}}
                            </a>
                        </div>
                    </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

    <script>
        $(document).ready(function () {
            $('.desc_container p').addClass('.det lh-lg')
        })
    </script>

@endsection
